% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varband_cv.R
\name{varband_cv}
\alias{varband_cv}
\title{Perform nfolds-cross validation}
\usage{
varband_cv(x, w = FALSE, lasso = FALSE, lamlist = NULL, nlam = 60,
  flmin = 0.01, folds = NULL, nfolds = 5)
}
\arguments{
\item{x}{A n-by-p sample matrix, each row is an observation of the p-dim random vector.}

\item{w}{Logical. Should we use weighted version of the penalty or not? If \code{TRUE}, we use general weight. If \code{FALSE}, use unweighted penalty. Default is \code{FALSE}.}

\item{lasso}{Logical. Should we use l1 penalty instead of hierarchical group lasso penalty? Note that by using l1 penalty, we lose the banded structure in the resulting estimate. And when using l1 penalty, the becomes CSCS (Convex Sparse Cholesky Selection) introduced in Khare et al. (2016). Default value for \code{lasso} is \code{FALSE}.}

\item{lamlist}{A list of non-negative tuning parameters \code{lambda}.}

\item{nlam}{If lamlist is not provided, create a lamlist with length \code{nulam}. Default is 60.}

\item{flmin}{If lamlist is not provided, create a lamlist with ratio of the smallest and largest lambda in the list equal to \code{flmin}. Default is 0.01.}

\item{folds}{Folds used in cross-validation}

\item{nfolds}{If folds are not provided, create folds of size \code{nfolds}.}
}
\value{
A list object containing \describe{
\item{errs_fit: }{A \code{nlam}-by-\code{nfolds} matrix of negative Gaussian log-likelihood values on the CV test data sets. \code{errs[i,j]} is negative Gaussian log-likelihood values incurred in using \code{lamlist[i]} on fold \code{j}}.
\item{errs_refit: }{A \code{nlam}-by-\code{nfolds} matrix of negative Gaussian log-likelihood values of the refitting.}
\item{folds: }{Folds used in cross validation.}
\item{lamlist: }{\code{lambda} grid used in cross validation.}
\item{ibest_fit: }{index of \code{lamlist} minimizing CV negative Gaussian log-likelihood.}
\item{ibest_refit: }{index of \code{lamlist} minimizing refitting CV negative Gaussian log-likelihood.}
\item{i1se_fit: }{Selected value of \code{lambda} using the one-standard-error rule.}
\item{i1se_refit: }{Selected value of \code{lambda} of the refitting process using the one-standard-error rule.}
\item{L_fit: }{Estimate of L corresponding to \code{ibest_fit}.}
\item{L_refit: }{Refitted estimate of L corresponding to \code{ibest_refit}.}
}
}
\description{
Select tuning parameter by cross validation according to the likelihood on testing data, with and without refitting.
}
\examples{
set.seed(123)
p <- 50
n <- 50
true <- varband_gen(p = p, block = 5)
x <- sample_gen(L = true, n = n)
res_cv <- varband_cv(x = x, w = FALSE, nlam = 40, flmin = 0.03)
}
\seealso{
\code{\link{varband}} \code{\link{varband_path}}
}

