% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.t.R
\name{is.t}
\alias{is.t}
\title{Simplified Independent Samples T-Test}
\usage{
is.t(df, var1, var2, var.equal = TRUE, two.tailed = TRUE)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}.}

\item{var2}{the main independent/predictor variable, \eqn{X}.}

\item{var.equal}{logical (default set to \code{T}). When set to \code{var.equal = F}, will employ Welsh's correction to the t-test (for data that violate the equal variances assumption).}

\item{two.tailed}{logical (default set to \code{T}). When set to \code{two.tailed = F}, will return results of a one-sided t-test.}
}
\value{
This function returns the summary results table for an independent samples t-test, examining the mean differences of \code{var1} (in data frame \code{df}) between groups in \code{var2}.
}
\description{
This function simplifies the call for the independent samples t-test (is.t) on a given data frame.
}
\examples{
data <- mtcars

ttest <- is.t(data,mpg,am)
summary(ttest)

}
