% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_metric.R
\name{sigma_metric}
\alias{sigma_metric}
\title{Calculate Six Sigma Metric for Analytical Performance}
\usage{
sigma_metric(bias, cv, tea)
}
\arguments{
\item{bias}{Numeric. Observed bias (systematic error), expressed as a
percentage or in the same units as \code{tea}.}

\item{cv}{Numeric. Observed coefficient of variation (imprecision),
expressed as a percentage.}

\item{tea}{Numeric. Total allowable error specification, expressed as a
percentage or in the same units as \code{bias}.}
}
\value{
An object of class \code{c("sigma_metric", "valytics_ate", "valytics_result")},
which is a list containing:

\describe{
\item{sigma}{Numeric. The calculated sigma metric value.}
\item{input}{List with input parameters:
\itemize{
\item \code{bias}: Observed bias
\item \code{cv}: Observed CV
\item \code{tea}: Total allowable error
}
}
\item{interpretation}{List with performance interpretation:
\itemize{
\item \code{category}: Performance category (e.g., "World Class", "Good")
\item \code{defect_rate}: Approximate defect rate per million
}
}
}
}
\description{
Calculates the sigma metric, which quantifies analytical performance
in terms of the number of standard deviations between observed performance
and the allowable total error limit. Higher sigma values indicate better
performance and lower defect rates.
}
\details{
The sigma metric is calculated as:

\deqn{\sigma = \frac{TEa - |Bias|}{CV}}{Sigma = (TEa - |Bias|) / CV}

Where:
\itemize{
\item TEa = Total allowable error (quality specification)
\item Bias = Observed systematic error (absolute value used)
\item CV = Observed coefficient of variation
}

\strong{Interpretation Guidelines:}

The sigma metric provides a standardized way to assess method performance:
\itemize{
\item \strong{>= 6 sigma}: World class performance (<3.4 defects per million)
\item \strong{>= 5 sigma}: Excellent performance (~230 defects per million)
\item \strong{>= 4 sigma}: Good performance (~6,200 defects per million)
\item \strong{>= 3 sigma}: Marginal performance (~66,800 defects per million)
\item \strong{< 3 sigma}: Poor performance (unacceptable defect rates)
}

Note: These defect rates assume a 1.5 sigma shift (industry standard for
long-term process variation).
}
\section{Clinical Laboratory Context}{

In clinical laboratories, a sigma metric of 4 or higher is generally
considered acceptable for routine testing, while 6 sigma is the gold
standard. Methods with sigma < 3 require stringent QC procedures and
may not be suitable for clinical use without improvement.
}

\examples{
# Basic sigma calculation
sm <- sigma_metric(bias = 1.5, cv = 2.0, tea = 10)
sm

# World-class performance example
sm_excellent <- sigma_metric(bias = 0.5, cv = 1.0, tea = 8)
sm_excellent

# Marginal performance example
sm_marginal <- sigma_metric(bias = 3.0, cv = 3.0, tea = 12)
sm_marginal

# Using with ate_from_bv() for glucose
ate <- ate_from_bv(cvi = 5.6, cvg = 7.5)
# Assume observed bias = 1.5\%, CV = 2.5\%
sm <- sigma_metric(bias = 1.5, cv = 2.5, tea = ate$specifications$tea)
sm

# Access the sigma value directly
sm$sigma

}
\references{
Westgard JO, Westgard SA (2006). The quality of laboratory testing today:
an assessment of sigma metrics for analytic quality using performance data
from proficiency testing surveys and the CLIA criteria for acceptable
performance. \emph{American Journal of Clinical Pathology}, 125(3):343-354.

Westgard JO (2008). \emph{Basic Method Validation} (3rd ed.).
Westgard QC, Inc.
}
\seealso{
\code{\link[=ate_from_bv]{ate_from_bv()}} for calculating TEa from biological variation,
\code{\link[=ate_assessment]{ate_assessment()}} for comprehensive performance assessment
}
