% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valuemap.R
\name{valuemap_h3}
\alias{valuemap_h3}
\title{Making choropleth map with data.frame of h3 address}
\usage{
valuemap_h3(
  data,
  map = providers$OpenStreetMap,
  legend.cut = NULL,
  palette = "Blues",
  show.text = TRUE,
  text.color = "black",
  text.format = function(x) x
)
}
\arguments{
\item{data}{A data.frame object who has "h3_addr" & "value" columns ("value" column must be numeric type)}

\item{map}{A map name of leaflet::providers}

\item{legend.cut}{A numeric vector which means color legend boundary values}

\item{palette}{A color name of RColorBrewer palettes}

\item{show.text}{A boolean who determines showing "value" number on center of polygons}

\item{text.color}{A color name for "value" number text on center of polygons}

\item{text.format}{A format function for "value" number text on center of polygons}
}
\value{
A leaflet object.
}
\description{
This function make a leaflet object.
You can easily visualize your data.frame with h3 address "name" column based on "value" column.
You have options :
  background map (= map)
  color legend boundary values (= legend.cut)
  color palette for color legend (= palette)
  showing "value" number on center of polygons (= show.text)
  color for "value" number text on center of polygons (= text.color)
}
\examples{
if (interactive()){
  valuemap_h3(seoul_h3, legend.cut=1:6, show.text=FALSE)
}
}
