# Tests functions which get ForceDecks data
num_cols_profiles <- 6
num_cols_result_definitions <- 12
num_cols_tests <- 13
num_cols_trials <- 23
num_cols_test_attributes <- 5

test_that("STEP 1: get_forcedecks_data() works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_data()
  
  # Expect a list of 4 results
  expect_equal(length(x), 4)
  
  # Expect a profiles dataframe with >0 rows and 6 cols
  expect_gt(dim(x$profiles)[1], 0)
  expect_equal(dim(x$profiles)[2], num_cols_profiles)
  
  # Expect result_definitions with >0 rows and 12 cols
  expect_gt(dim(x$result_definitions)[1], 0)
  expect_equal(dim(x$result_definitions)[2], num_cols_result_definitions)
  
  # Expected number of columns for tests
  expect_gt(dim(x$tests)[1], 0)
  expect_equal(dim(x$tests)[2], num_cols_tests)
  
  # Expected number of columns for trials
  expect_gt(dim(x$trials)[1], 0)
  expect_equal(dim(x$trials)[2], num_cols_trials)
})

test_that("STEP 2: get_forcedecks_data(include_attributes = TRUE) works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_data(include_attributes = TRUE)
  
  # Expect a list of 5 results
  expect_equal(length(x), 5)
  
  # Expect a profiles dataframe with >0 rows and 6 cols
  expect_gt(dim(x$profiles)[1], 0)
  expect_equal(dim(x$profiles)[2], num_cols_profiles)
  
  # Expect result_definitions with >0 rows and 12 cols
  expect_gt(dim(x$result_definitions)[1], 0)
  expect_equal(dim(x$result_definitions)[2], num_cols_result_definitions)
  
  # Expected number of columns for tests
  expect_gt(dim(x$tests)[1], 0)
  expect_equal(dim(x$tests)[2], num_cols_tests)
  
  # Expected number of columns for trials
  expect_gt(dim(x$trials)[1], 0)
  expect_equal(dim(x$trials)[2], num_cols_trials)
  
  # Expected number of columns for test_attributes
  expect_gt(dim(x$test_attributes)[1], 0)
  expect_equal(dim(x$test_attributes)[2], num_cols_test_attributes)
  
})

test_that("STEP 3: get_forcedecks_tests_trials() works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_tests_trials()
  
  # Expect list length
  expect_equal(length(x), 2)
  
  # Expected number of columns for tests
  expect_gt(dim(x$tests)[1], 0)
  expect_equal(dim(x$tests)[2], num_cols_tests)
  
  # Expected number of columns for trials
  expect_gt(dim(x$trials)[1], 0)
  expect_equal(dim(x$trials)[2], num_cols_trials)
})

test_that("STEP 4: get_forcedecks_tests_trials(include_attributes = TRUE) works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_tests_trials(include_attributes = TRUE)
  expect_equal(length(x), 3)
  
  # Expected number of columns for tests
  expect_gt(dim(x$tests)[1], 0)
  expect_equal(dim(x$tests)[2], num_cols_tests)
  
  # Expected number of columns for trials
  expect_gt(dim(x$trials)[1], 0)
  expect_equal(dim(x$trials)[2], num_cols_trials)
  
  # Expected number of columns for test_attributes
  expect_gt(dim(x$test_attributes)[1], 0)
  expect_equal(dim(x$test_attributes)[2], num_cols_test_attributes)
})

test_that("STEP 5: get_forcedecks_tests_only() works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_tests_only()
  
  # Expect >0 rows and 13 cols
  expect_gt(dim(x)[1], 0)
  expect_equal(dim(x)[2], num_cols_tests)
})

test_that("STEP 6: get_forcedecks_tests_only(include_attributes = TRUE) works as expected", {
  # Creds
  reset_credentials()
  set_start_date(Sys.getenv("start_date"))
  
  x <- get_forcedecks_tests_only(include_attributes = TRUE)
  
  # Expect list length
  expect_equal(length(x), 2)
  
  # Expected number of columns for tests
  expect_gt(dim(x$tests)[1], 0)
  expect_equal(dim(x$tests)[2], num_cols_tests)
  
  # Expected number of columns for test_attributes
  expect_gt(dim(x$attributes)[1], 0)
  expect_equal(dim(x$attributes)[2], num_cols_test_attributes)
})