% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_vald_trends}
\alias{plot_vald_trends}
\title{Time-Series Visualization of Performance Metrics}
\usage{
plot_vald_trends(
  data,
  date_col = "Testdate",
  metric_col,
  group_col = NULL,
  facet_col = NULL,
  title = NULL,
  smooth = FALSE
)
}
\arguments{
\item{data}{Data frame. Test data with a date column and at least one metric.}

\item{date_col}{Character. Name of the date column. Default is "Testdate".}

\item{metric_col}{Character. Name of the metric to plot.}

\item{group_col}{Character. Optional grouping variable (e.g., "profileId",
"sports"). If provided, separate lines are drawn for each group.}

\item{facet_col}{Character. Optional faceting variable (e.g., "sex").
Creates separate panels for each level.}

\item{title}{Character. Plot title. If NULL, auto-generates from metric name.}

\item{smooth}{Logical. If TRUE, adds a smoothed trend line. Default is FALSE.}
}
\value{
A ggplot2 object.
}
\description{
Creates professional line plots showing how performance metrics change over
time for individual athletes or groups. Useful for tracking training
adaptations, injury recovery, and seasonal trends.
}
\details{
Plot Longitudinal Trends for VALD Metrics
}
\examples{
\donttest{
if (FALSE) {
  test_datasets <- split_by_test(final_analysis_data)

  # Plot individual athlete trends
  plot_vald_trends(
    data = test_datasets$CMJ,
    metric_col = "PEAK_FORCE_Both",
    group_col = "profileId",
    facet_col = "sex"
  )

  # Plot sport-level averages
  sport_avg <- test_datasets$CMJ \%>\%
    group_by(Testdate, sports) \%>\%
    summarise(avg_force = mean(PEAK_FORCE_Both, na.rm = TRUE))

  plot_vald_trends(
    data = sport_avg,
    date_col = "Testdate",
    metric_col = "avg_force",
    group_col = "sports"
  )
}
}
}
