% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.r
\name{uniqueBidirection}
\alias{uniqueBidirection}
\title{uniqueBidirection}
\usage{
uniqueBidirection(x)
}
\arguments{
\item{x}{a data.frame}
}
\value{
A data.frame that is unique regardless of direction
}
\description{
Find unique rows of a data.frame regardless of the order they appear
}
\details{
Sorts individual rows to get uniques regardless of order of appearance.
}
\examples{

ex <- data.frame(One=c('a', 'c', 'a', 'd', 'd', 'c', 'b'), 
Two=c('b', 'd', 'b', 'e', 'c', 'd', 'a'),
stringsAsFactors=FALSE)

# make a bigger version
exBig <- ex
for(i in 1:1000)
{
    exBig <- rbind(exBig, ex)
}

dim(exBig)

uniqueBidirection(ex)
uniqueBidirection(exBig)

ex3 <- dplyr::bind_cols(ex, tibble::tibble(Three=rep('a', nrow(ex))))
uniqueBidirection(ex3)

}
\author{
Jared P. Lander
}
