% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansPlotting.r
\name{plot.kmeans}
\alias{plot.kmeans}
\title{plot.kmeans}
\usage{
\method{plot}{kmeans}(
  x,
  data = NULL,
  class = NULL,
  size = 2,
  legend.position = c("right", "bottom", "left", "top", "none"),
  title = "K-Means Results",
  xlab = "Principal Component 1",
  ylab = "Principal Component 2",
  ...
)
}
\arguments{
\item{x}{A \code{\link{kmeans}} object.}

\item{data}{The data used to kit the \code{\link{kmeans}} object.}

\item{class}{Character name of the "true" classes of the data.}

\item{size}{Numeric size of points}

\item{legend.position}{Character indicating where the legend should be placed.}

\item{title}{Title for the plot.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{\dots}{Not Used.}
}
\value{
A ggplot object
}
\description{
Plot the results from a k-means object
}
\details{
Plots the results of k-means with color-coding for the cluster membership.  If \code{data} is not provided, then just the center points are calculated.
}
\examples{

k1 <- kmeans(x=iris[, 1:4], centers=3)
plot(k1)
plot(k1, data=iris)
plot(k1, data=iris, class=Species)

}
\seealso{
kmeans fortify ggplot plot.kmeans
}
\author{
Jared P. Lander
}
