% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscgh.R
\name{uscgh.2010.decode}
\alias{uscgh.2010.decode}
\title{Return text describing the meaning of a value in a column}
\usage{
uscgh.2010.decode(colname, colvalue = "", warnings = TRUE)
}
\arguments{
\item{colname}{Name of the column to be described.}

\item{colvalue}{Value whose description is wanted (\"""\" -- the
default -- to describe, generically, `colname` itself).}

\item{warnings}{Whether a `(colname,colvalue)` tuple that is
not successfully decoded should produce a warning message.  (In
any event, the result will be NULL.)}
}
\value{
A character string describing the `colname` or
  `(colname,colvalue)` tuple, if found.  If not found, `NULL` is
  returned (and, if `warnings` is `TRUE`, a warning is generated).
}
\description{
uscgh.2010.decode() returns a textual description of a cell
}
\details{
takes as input the name of a column in the Geographic Header file
from the 2010 US census, and a value found in that column, and
attempts to return a description of the meaning of that value.
}
\examples{
uscgh.2010.decode('SUMLEV', 40)

}
\seealso{
'RShowDoc("a-tour", package="us.census.geoheader")' for a
  short tour of a few columns of the database
}
