% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_file_extension}
\alias{extract_file_extension}
\title{Extract file extension from URLs or paths}
\usage{
extract_file_extension(url)
}
\arguments{
\item{url}{A character vector of URLs or paths from which to extract file
extensions.}
}
\value{
A character vector with the file extension for each URL or path.
Extensions are returned without the dot (e.g., "jpg" instead of ".jpg"),
and URLs or paths without extensions will return \code{NA}.
}
\description{
This function parses each input URL or path and extracts the file extension,
if present. It is particularly useful for identifying the type of files
referenced in URLs.
}
\examples{
extract_file_extension(
  c(
    "http://example.com/image.jpg",
    "https://example.com/archive.zip",
    "http://example.com/"
  )
)
}
