% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.monitor.delete.R
\name{uptimerobot.monitor.delete}
\alias{uptimerobot.monitor.delete}
\title{Delete a monitor}
\usage{
uptimerobot.monitor.delete(api.key, id)
}
\arguments{
\item{api.key}{string with a valid key for connecting to Uptimerobot API.}

\item{id}{numeric or integer with the ID of the monitor to delete.}
}
\value{
The function returns \code{TRUE} in case success. An error is thrown otherwise.
}
\description{
\code{uptimerobot.monitor.delete} remove a monitor and all existing statistics of it.
}
\examples{
\dontrun{
 # Let's assume the api.key is available into the environment variable KEY
 api.key <- Sys.getenv("KEY", "")

 # Create a monitor and get its monitor.id
 monitor.id <- uptimerobot.monitor.new(api.key,
   friendly.name="Open Analytics",
   url="https://gabrielebaldassarre.com", type="http"
 )

 # Change the friendly name of the monitor
  if(uptimerobot.monitor.edit(api.key,
     monitor.id,
     friendly.name="Open Analytics - gabrielebaldassarre.com"
  ){
   message("Monitor has been successfully edited!")
 }

 # Delete the just-made monitor
 if(uptimerobot.monitor.delete(api.key, monitor.id){
   message("Monitor has been successfully deleted!")
 }
}
}
\author{
Gabriele Baldassarre
}

