# -------------------------------------------------------------------------------
#   This file is part of 'unityForest'.
#
# 'unityForest' is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# 'unityForest' is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with 'unityForest'. If not, see <http://www.gnu.org/licenses/>.
#
#  NOTE: 'unityForest' is a fork of the popular R package 'ranger', written by Marvin N. Wright.
#  Most R and C++ code is identical with that of 'ranger'. The package 'unityForest'
#  was written by taking the original 'ranger' code and making any
#  changes necessary to implement unity forests.
#
# -------------------------------------------------------------------------------

##' Unity Forest (UFO) Framework
##' 
##' This package implements the unity forest (UFO) framework.
##' UFOs are a random forest variant designed to better take covariates with
##' purely interaction-based effects into account, including interactions for which none of the involved
##' covariates exhibits a marginal effect.
##' While this framework tends to improve discrimination and predictive accuracy compared
##' to standard random forests, it also facilitates the identification and interpretation of
##' (marginal or interactive) effects: In addition to the UFO algorithm for tree construction,
##' the package includes the unity variable importance measure (unity VIM), which quantifies
##' covariate effects under the conditions in which they are strongest - either marginally 
##' or within subgroups defined by interactions - as well as covariate-representative tree
##' roots (CRTRs) that provide interpretable visualizations of these conditions.
##' Categorical and continuous outcomes are supported.
##' 
##' The main functions of the package are:
##' \itemize{
##' \item \code{\link{unityfor}}: Construct a UFO and compute the unity VIM.
##' \item \code{\link{predict.unityfor}}: Predict using a UFO fitted using \code{\link{unityfor}}.
##' \item \code{\link{reprTrees}}: Select and visualize covariate-representative tree roots (CRTRs) based on a \code{\link{unityfor}} object.
##' }
##'
##' This package is a fork of the R package 'ranger' that implements random forests using an
##' efficient C++ implementation. The documentation is partly taken from 'ranger'.
##'
##' The code in the example sections can be used as a template for basic application scenarios.
##'
##' @references
##' \itemize{
##'   \item Hornung, R., Hapfelmeier, A. (2026). Unity Forests: Improving Interaction Modelling and Interpretability in Random Forests. arXiv:2601.07003, <\doi{10.48550/arXiv.2601.07003}>.
##'   \item Wright, M. N., Ziegler, A. (2017). ranger: A fast implementation of random forests for high dimensional data in C++ and R. Journal of Statistical Software 77:1-17, <\doi{10.18637/jss.v077.i01}>.
##'   \item Breiman, L. (2001). Random forests. Machine Learning 45:5-32, <\doi{10.1023/A:1010933404324}>.
##'   \item Malley, J. D., Kruppa, J., Dasgupta, A., Malley, K. G., & Ziegler, A. (2012). Probability machines: consistent probability estimation using nonparametric learning machines. Methods of Information in Medicine 51:74-81, <\doi{10.3414/ME00-01-0052}>.
##'   }
##'
##' @name unityForest-package
##' @aliases unityForest
NULL