% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_slides.R
\name{html_slides}
\alias{html_slides}
\title{Convert to UNHCR branded HTML presentation}
\usage{
html_slides(other_css = NULL, ...)
}
\arguments{
\item{other_css}{Add extra css}

\item{...}{extra parameters to pass to \code{xaringan::moon_reader}}
}
\value{
An R Markdown output format.
}
\description{
Format for converting from R Markdown to an UNHCR branded HTML presentation
}
\examples{
\dontrun{
# Requires pandoc

# Create an R Markdown example file
rmd_content <- "---
 title: 'Example UNHCR HTML Slides'
 output: unhcrdown::html_slides
 ---

 ## Introduction

 This is an example of a UNHCR-branded HTML slides created using `unhcrdown::html_slides`.
 "

# Write the R Markdown content to a file
example_file <- tempfile(fileext = ".Rmd")
writeLines(rmd_content, example_file)

# Render the R Markdown file
rmarkdown::render(example_file,
  output_format = unhcrdown::html_slides(),
  output_dir = tempdir()
)

# View the rendered HTML file
browseURL(render_file)
}
}
