% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryGxE}
\alias{umxSummaryGxE}
\alias{umxSummary.MxModelGxE}
\title{Summarize a GxE model}
\usage{
umxSummaryGxE(
  model = NULL,
  digits = 2,
  xlab = NA,
  location = "topleft",
  separateGraphs = FALSE,
  gg = TRUE,
  file = getOption("umx_auto_plot"),
  returnStd = NULL,
  std = NULL,
  reduce = FALSE,
  CIs = NULL,
  report = c("markdown", "html"),
  show = NULL,
  ...
)
}
\arguments{
\item{model}{A fitted \code{\link[=umxGxE]{umxGxE()}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{If TRUE, both std and raw plots in one figure (default FALSE)}

\item{gg}{Whether to use ggplot to create the graphs (default TRUE)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{std}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{"markdown" or "html" = open a browser for copyable tables}

\item{show}{not doing anything yet (required for all summary functions)}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item optional \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
Summarize a genetic moderation model, as returned by \code{\link[=umxGxE]{umxGxE()}}. Prints graphs of A, C, and E, standardized and raw.
}
\details{
Note: see also \code{\link[=umxReduce]{umxReduce()}} which knows how to reduce a GxE model.
}
\examples{
\dontrun{
# The total sample has been subdivided into a young cohort, 
# aged 18-30 years, and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows 1 == MZ females 2 == MZ males 
# 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
require(umx)
data(twinData) 
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, zygosity == "MZFF", selVars)
dzData  = subset(twinData, zygosity == "DZMM", selVars)
# Exclude cases with missing Def
mzData = mzData[!is.na(mzData[selDefs[1]]) & !is.na(mzData[selDefs[2]]),]
dzData = dzData[!is.na(dzData[selDefs[1]]) & !is.na(dzData[selDefs[2]]),]
m1 = umxGxE(selDVs = "bmi", selDefs = "age", sep="", dzData = dzData, mzData = mzData)
# Plot Moderation
umxSummaryGxE(m1)
umxSummaryGxE(m1, location = "topright")
umxSummaryGxE(m1, separateGraphs = FALSE)
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=umxGxE]{umxGxE()}}, \code{\link[=umxReduce]{umxReduce()}}, \code{\link[=plot]{plot()}}, [umxSummary)] all work for IP, CP, GxE, and ACE models.
}

[umxSummary)]: R:umxSummary)

Other Summary functions: 
\code{\link{umxSummary.MxModel}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryIP}()},
\code{\link{umxSummaryMRDoC}()}
}
\concept{Summary functions}
