% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfKNN.r
\name{selfKNN}
\alias{selfKNN}
\title{Self KNN}
\usage{
selfKNN(train, K = 1)
}
\arguments{
\item{train}{numeric matrix or data frame.}

\item{K}{number of neighbours considered.}
}
\value{
The function returns a list with the following components:
\item{D}{matrix of squared root of the distances between observations and their nearest neighbours.}
\item{idx}{Index of K nearest neighbours of each observation.}
}
\description{
This function performs the k-Nearest Neighbour algorithm without class estimation, but only computation of distances and neighbours.
}
\examples{
x<-matrix(runif(10),ncol=2)
plot(x,pch=c("1","2","3","4","5"))
selfKNN(x,K=4)
}

