% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_mcmc.R
\name{post_analy_cor}
\alias{post_analy_cor}
\title{Creates and saves correlation plots based on posterior similarity matrices}
\usage{
post_analy_cor(outpu_new, titles, pdf_path, ords = "none")
}
\arguments{
\item{outpu_new}{the output of the pairwise_clus function, and a list whose length is the number of datasets being integrated, and each elemnt of which is a posterior similarity matrix.  The dimension of each symmetric matrix is the number of samples in the respective dataset, and elements in the matrix are values between 0 and 1, and estimate of the probability 2 samples find themselves in the same clustering.}

\item{titles}{a vector of strings of length number of integrated datasets.  Elements of the vector are titles in the respective correlation plots}

\item{pdf_path}{file path where the plots will be saved as a pdf.}

\item{ords}{whether the correlation plots should be reordered according to that of hierarchical clustering for a more comprehensible plot.  Defaults to 'none'.  Passing any string apart from 'none' (i.e., 'yes') will result in the re-ordering.}
}
\value{
dendro_ord regardless of whether correlation plots are reordered according to hierarchical clustering, a list of reorderings is returned of length the number of datasets on which analysis was performed.
}
\description{
Creates and saves correlation plots based on posterior similarity matrices
}
\examples{
data(data_and_output)
\dontrun{clus_save <- TWLsample(misaligned_mat,misaligned,output_every=50,num_its=5000,manip=FALSE)
outpu_new <- pairwise_clus(clus_save,BURNIN=2000)
post_analy_cor(outpu_new,c("title1","title2","title3","title4","title5"),
tempfile(),ords='none') 
clus_labs <- post_analy_clus(outpu_new,clus_save,c(2:6),rep(0.6,5),c("title1","title2",
"title3","title4","title5"),tempfile())
output_nest <- cross_dat_analy(clus_save,4750)
}
}
