% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CfFuncs.R
\name{xirr}
\alias{xirr}
\title{The IRR is returned as an effective annual rate}
\usage{
xirr(cf, d, tau = NULL, comp_freq = 1, interval = c(-0.99999, 10), ...)
}
\arguments{
\item{cf}{The cashflow}

\item{d}{The dates when each cashflow occurs. Same length as the cashflow. Only used if tau is NULL. Assumes act/365 fractions}

\item{tau}{The year fractions when each cashflow occurs. Same length as the cashflow}

\item{comp_freq}{The compounding frequency used. Most relevant cases are 1 for yearly, 2 twice a year, 4 quarterly, 12 monthly, 0 no compounding, Inf continuous}

\item{interval}{A length 2 vector that indicates the root finding algorithm where to search for the irr}

\item{...}{Other arguments to be passed on to uniroot}
}
\description{
Internal Rate of Return of an irregular cashflow (IRR)
}
\examples{
xirr(cf = c(-1, 1.5), d = Sys.Date() + c(0, 365))
}
