% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fvQuartPaidAnnuityCompQuarterly.R
\name{fvQuarterlyPaidAnnuityCompQuarterly}
\alias{fvQuarterlyPaidAnnuityCompQuarterly}
\title{Calculates Future Value of Quarterly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.}
\usage{
fvQuarterlyPaidAnnuityCompQuarterly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}.
}
\description{
Calculates Future Value of Quarterly Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly.
}
\details{
According to \insertCite{brook;textual}{tvmComp}, an Annuity is a series of equal cash payments at regular intervals across time.
The method \code{fvQuarterlyPaidAnnuityCompQuarterly()} is developed to calculate Future Value of Quarterly-Paid Ordinary Annuity or Annuity Due that is Compounded Quarterly. The method gives FV when values are passed to its four arguments. Here \code{r} is annual rate, \code{n} is number of years, \code{pmt} is amount of one annuity and \code{bgn} is the mode (1 when annuity payment occurs at the beginning of the period; 0 for end of period payments)
}
\examples{
fvQuarterlyPaidAnnuityCompQuarterly(0.08,10,-50,1)
fvQuarterlyPaidAnnuityCompQuarterly(0.08,10,-50,0)
fvQuarterlyPaidAnnuityCompQuarterly(.08,10,50,1)
fvQuarterlyPaidAnnuityCompQuarterly(.08,10,50,0)
}
\references{
\insertRef{brook}{tvmComp}
}
\author{
MaheshP. Kumar, \email{maheshparamjitkumar@gmail.com}
}
