% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cross_sectional_tvem_example.R
\name{simulate_cross_sectional_tvem_example}
\alias{simulate_cross_sectional_tvem_example}
\title{simulate_cross_sectional_tvem_example: Simulate a cross-sectional dataset for 
demonstrating tvem.}
\usage{
simulate_cross_sectional_tvem_example(
  n_subjects = 300,
  min_time = 7,
  max_time = 7,
  simulate_binary = FALSE,
  sigma_x1 = 2,
  sigma_x2 = 2,
  truncate_for_realism = TRUE,
  round_digits = 3,
  sigma_y = 1.5,
  mu_x1_function = function(t) {
     6 - 2 * sqrt(pmax(0, ((t - min(t))/7) - 0.2))
 },
  mu_x2_function = function(t) {
     3 + sqrt(pmax(0, ((t - min(t))/7) - 0.5))
 },
  beta0_y_function = function(t) {
     1 - 0.3 * sqrt((t - min(t))/7)
 },
  beta1_y_function = function(t) {
     0.5 * ((t - min(t))/7)^2
 },
  beta2_y_function = function(t) {
     rep(0.2, length(t))
 }
)
}
\arguments{
\item{n_subjects}{Number of subjects in dataset}

\item{min_time}{The time point at the end of the simulated time interval}

\item{max_time}{The time point at the end of the simulated time interval}

\item{simulate_binary}{Whether the simulated data should be binary}

\item{sigma_x1}{Standard deviation of covariate 1, assumed homoskedastic over time}

\item{sigma_x2}{Standard deviation of covariate 2, assumed homoskedastic over time}

\item{truncate_for_realism}{Whether to prevent simulated values from going below 0 or above 10, 
in order to imitate survey data; used only for normally distributed outcomes.
Set this to FALSE if you are running a simulation, in order to avoid losing coverage
due to departing from the parametric model.}

\item{round_digits}{Number of digits at which to round the generated data; used only for normally distributed outcomes}

\item{sigma_y}{Error standard deviation of y, only used if the outcomes are to be normal rather than binary}

\item{mu_x1_function}{Mean of covariate 1 as function of time}

\item{mu_x2_function}{Mean of covariate 2 as function of time}

\item{beta0_y_function}{TVEM intercept as function of time}

\item{beta1_y_function}{TVEM coefficient of covariate 1 as function of time}

\item{beta2_y_function}{TVEM coefficient of covariate 2 as function of time}
}
\value{
A simulated dataset with the following variables:
\describe{
\item{subject_id}{Subject ID}
\item{time}{Observation time}
\item{x1}{First covariate}
\item{x2}{Second covariate}
\item{y}{Outcome variable}
}
}
\description{
This differs from what simulate_tvem_example does, in that each
participant (subject) is only measured at a single measurement time,
but the measurement time of each subject is random.  This might
simulate a sample of people of many different ages, where age 
is treated as a continuous number.
}
\details{
By default, the data-generating model has a time-varying intercept,
and two time-varying covariates named x1 and x2. 
x1 has a time-varying effect and x2 has a time-invariant effect.
}
\examples{
set.seed(16802)
the_data <- simulate_tvem_example(simulate_binary=TRUE)

}
\keyword{Statistics|datagen}
