% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tvcure.R
\name{plot.tvcure}
\alias{plot.tvcure}
\title{Plot visual information related to a tvcure object.}
\usage{
\method{plot}{tvcure}(x, ngrid=300, ci.level=.95, pages=0, select=NULL,
                             fill=TRUE, pointwise=TRUE, mar=c(4,5,1,1),
                             xlim0=NULL, ylim0=NULL,
                             xlim1=NULL, ylim1=NULL, xlim2=NULL, ylim2=NULL,
                             equal.ylims=TRUE,...)
}
\arguments{
\item{x}{a \code{\link{tvcure.object}}.}

\item{ngrid}{(optional) number of points used to plot the fitted additive terms. (Default: 300).}

\item{ci.level}{(optional) nominal level for the plotted pointwise credible intervals. (Default: 0.95).}

\item{pages}{The number of pages over which to spread the output. For example, if pages=1 then all terms will be plotted on one page with the layout performed automatically. Set to 0 to have the routine leave all graphics settings as they are. (Default 0).}

\item{select}{Allows the plot for a single model term to be selected for printing. e.g. if you just want the plot for the second smooth term set select=2. The plot of the reference hazard \eqn{f_0(t)} and cumulative hazard \eqn{F_0(t)} functions is provided when select=0. When select=-1, only the reference hazard is plotted.(Default: NULL).}

\item{fill}{Logical indicating whether credible regions should be greyed out. (Default: TRUE).}

\item{pointwise}{Logical indicating whether only pointwise credible intervals should be plotted for additive terms. When FALSE, simultaneous credible regions are also provided. (Default: TRUE).}

\item{mar}{A numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot. (Default: c(4,5,1,1)).}

\item{xlim0}{Vector of length 2 specifying x-axis limits when plotting the estimated reference hazard function \eqn{\exp(\beta_0)f_0(t)}.}

\item{ylim0}{Vector of length 2 specifying y-axis limits when plotting the estimated reference hazard function \eqn{\exp(\beta_0)f_0(t)}.}

\item{xlim1}{Vector of length 2 specifying (common) x-axis limits when plotting the fitted additive term(s) in the long-term survival submodel. (Default: NULL).}

\item{ylim1}{Vector of length 2 specifying (common) y-axis limits when plotting the fitted additive term(s) in the long-term survival submodel. (Default: NULL).}

\item{xlim2}{Vector of length 2 specifying (common) x-axis limits when plotting the fitted additive term(s) in the short-term survival submodel. (Default: NULL).}

\item{ylim2}{Vector of length 2 specifying (common) y-axis limits when plotting the fitted additive term(s) in the short-term survival submodel. (Default: NULL).}

\item{equal.ylims}{logical indicating if the same y-limits must be used when plotting the fitted additive terms from the same submodel. It can be overriden by non-NULL values for \code{ylim1} or \code{ylim2}. (Default: TRUE).}

\item{...}{additional generic plotting arguments.}
}
\value{
In addition to the plots, an invisible list generated by the \code{\link{additive.tvcure}} function is returned.
}
\description{
Visualization of the estimated additive terms and of the reference (cumulative) hazard function in a tvcure object.
}
\details{
Plot of the fitted additive terms, as well as of the reference hazard \eqn{f_0(t)} and cumulative hazard \eqn{F_0(t)} functions of the fitted tvcure model in \code{x}.
}
\examples{
\donttest{
require(tvcure)
## Simulated data generation
beta = c(beta0=.4, beta1=-.2, beta2=.15) ; gam = c(gam1=.2, gam2=.2)
data = simulateTVcureData(n=500, seed=123, beta=beta, gam=gam,
                          RC.dist="exponential",mu.cens=550)$rawdata
## TVcure model fitting
tau.0 = 2.7 ; lambda1.0 = c(40,15) ; lambda2.0 = c(25,70) ## Optional
model = tvcure(~z1+z2+s(x1)+s(x2), ~z3+z4+s(x3)+s(x4), data=data,
               tau.0=tau.0, lambda1.0=lambda1.0, lambda2.0=lambda2.0)
plot(model,pages=1)
}

}
\references{
Lambert, P. and Kreyenfeld, M. (2025).
Time-varying exogenous covariates with frequently changing values in double additive cure survival model: an application to fertility.
\emph{Journal of the Royal Statistical Society, Series A}. <doi:10.1093/jrsssa/qnaf035>
}
\seealso{
\code{\link{tvcure}}, \code{\link{tvcure.object}}, \code{\link{print.tvcure}}
}
\author{
Philippe Lambert \email{p.lambert@uliege.be} based on the plot.gam function in mgcv for the \code{pages} argument.
}
