% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvOLS.R
\name{tvOLS}
\alias{tvOLS}
\alias{tvOLS.matrix}
\alias{tvOLS.tvlm}
\alias{tvOLS.tvar}
\alias{tvOLS.tvvar}
\title{Time-Varying Ordinary Least Squares}
\usage{
tvOLS(x, ...)

\method{tvOLS}{matrix}(
  x,
  y,
  z = NULL,
  ez = NULL,
  bw,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian"),
  singular.ok = TRUE,
  ...
)

\method{tvOLS}{tvlm}(x, ...)

\method{tvOLS}{tvar}(x, ...)

\method{tvOLS}{tvvar}(x, ...)
}
\arguments{
\item{x}{An object used to select a method.}

\item{...}{Other arguments passed to specific methods.}

\item{y}{A vector with dependent variable.}

\item{z}{A vector with the variable over which coefficients are smooth over.}

\item{ez}{(optional) A scalar or vector with the smoothing values. If 
values are not included then the vector \code{z} is used instead.}

\item{bw}{A numeric vector.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant
or "ll" for local linear.}

\item{tkernel}{A character, either "Triweight" (default), "Epa" or "Gaussian" kernel function.}

\item{singular.ok}{Logical. If FALSE, a singular model is an error.}
}
\value{
\code{tvOLS} returns a list containing:
\item{coefficients}{A vector of length obs, number of observations time observations.}
\item{fitted}{A vector of length obs with the fitted values from the estimation.}
\item{residuals}{A vector of length obs with the residuals from the estimation.}
}
\description{
\code{tvOLS} estimate time-varying coefficient of univariate 
linear models using the kernel smoothing OLS.
}
\examples{
tau <- seq(1:500)/500
beta <- data.frame(beta1 = sin(2*pi*tau), beta2 = 2*tau)
X <- data.frame(X1 = rnorm(500), X2 = rchisq(500, df = 4))
error <- rt(500, df = 10)
y <- apply(X*beta, 1, sum) + error
coef.lm <- stats::lm(y~0+X1+X2, data = X)$coef
coef.tvlm <-  tvOLS(x = as.matrix(X), y = y, bw = 0.1)$coefficients
plot(tau, beta[, 1], type="l", main="", ylab = expression(beta[1]), xlab = expression(tau),
ylim = range(beta[,1], coef.tvlm[, 1]))
abline(h = coef.lm[1], col = 2)
lines(tau, coef.tvlm[, 1], col = 4)
legend("topright", c(expression(beta[1]), "lm", "tvlm"), col = c(1, 2, 4), bty="n", lty = 1)

}
\seealso{
\code{\link{bw}} for bandwidth selection, \code{\link{tvLM}} and
\code{\link{tvAR}}.
}
