% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ate.R
\name{plot_ate}
\alias{plot_ate}
\title{Plot estimated treatment effects}
\usage{
plot_ate(
  fit,
  decrease = FALSE,
  conf.int = 0.95,
  xlab = "Time",
  ylim = c(-1, 1),
  xlim = NULL,
  plot.configs = list(ylab = NULL, main = NULL, lty = 1, lwd = 2, col = "black",
    add.null.line = TRUE, null.line.lty = 2, ci.lty = 5, ci.lwd = 1.5, ci.col =
    "darkgrey"),
  ...
)
}
\arguments{
\item{fit}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{decrease}{A logical value indicating the type of curve difference to display.
If \code{decrease = FALSE} (default), the difference in cumulative
incidence functions (CIFs) is plotted. If \code{decrease = TRUE},
the difference in survival functions is plotted instead.}

\item{conf.int}{Confidence level for the pointwise confidence intervals
If \code{conf.int = NULL}, no confidence intervals are provided.}

\item{xlab}{Label for the x-axis.}

\item{ylim}{A numeric vector of length 2 specifying the limits of the y-axis.
Defaults to \code{ylim = c(-1, 1)}.}

\item{xlim}{A numeric vector of length 2 specifying the limits of the x-axis.
If \code{xlim = NULL} (default), the limits are determined automatically from the data.}

\item{plot.configs}{A named \code{list} of additional plot configurations. Common entries include:

\itemize{
\item \code{ylab}: character, label for the y-axis (default: \code{ylab=NULL}, use the default label).
\item \code{main}: character, title for the plot (default: \code{main=NULL}, use the default label).
\item \code{lty}: line type for effect curve (default: \code{lty=1}).
\item \code{lwd}: line width for effect curve (default: \code{lwd=2}).
\item \code{col}: line color for effect curve (default: \code{col="black"}).
\item \code{add.null.line}: logical, whether to draw a horizontal line at 0 (default: \code{add.null.line=TRUE}, add the null line).
\item \code{null.line.lty}: line type for horizontal line at 0 (default: \code{null.line.lty=2}.
\item \code{ci.lty}: line type for confidence interval curves (default: \code{ci.lty=5}).
\item \code{ci.lwd}: line width for confidence interval curves (default: \code{ci.lwd=1.5}).
\item \code{ci.col}: line color for confidence interval curves (default: \code{ci.col="darkgrey"}).
}}

\item{...}{Additional graphical arguments passed to function \code{\link{plot.default}} or function \code{\link{curve}}}
}
\value{
Plot the average treatment effect (ATE) results from a tteICE object
}
\description{
This function plots the estimated treatment effect,
defined as the difference in potential cumulative incidences under treated and control groups,
along with pointwise confidence intervals.
}
\seealso{
\code{\link[graphics]{plot.default}},
\code{\link[graphics]{points}},
\code{\link[graphics]{curve}},
\code{\link[tteICE]{plot.tteICE}}
}
\keyword{internal}
