% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{climate}
\alias{climate}
\title{FAOSTAT Temperature Change on Land}
\format{
A list of time series.
}
\source{
\href{https://data.giss.nasa.gov/gistemp/}{NASA-GISS GISTEMP}
}
\usage{
data(climate)
}
\description{
Statistics of surface temperature anomalies on land, based on NASA-GISS GISTEMP data.
Data Type:	Temperature Anomalies. Category:	Environment. Creation Date	2024.
}
\examples{
# Load climate list and plot one series
data(climate)
# climate <- loadfulldata(climate)
series <- climate[[1]]
ts.plot(series, ylab = "Temperature change (°C)", xlab = "Year",
        main = "Temperature change on land")
}
\references{
FAO, 2024. FAOSTAT Land, Inputs and Sustainability; Climate Change Indicators;
Temperature change on land.
GISTEMP Team, 2024: GISS Surface Temperature Analysis. NASA Goddard Institute for Space Studies.
Hansen, J. et al., 1981–2019: Multiple foundational studies on global temperature analysis.
}
\keyword{datasets}
