% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{NN3}
\alias{NN3}
\title{NN3 Time Series Competition - Dataset A}
\format{
A data frame with up to 126 rows and 111 columns. Each column corresponds to a different univariate monthly time series.
}
\source{
\href{http://www.neural-forecasting-competition.com/NN3/index.htm}{NN3 Time Series Forecasting Competition}
}
\usage{
data(NN3)
}
\description{
Monthly time series from the NN3 forecasting competition.
Data Type: Empirical business time series. Category: Benchmark. Observations: 50 to 126 per series, 111 series.
The dataset contains 111 univariate monthly time series from real business processes.
Each series has between 50 and 126 observations. Participants were asked to forecast the next 18 values, and performance was evaluated using the mean sMAPE across all series.
}
\details{
NN3 comprises monthly business time series with varying lengths. Forecast accuracy is typically
evaluated using sMAPE across a fixed holdout horizon.
}
\examples{
# Load NN3 dataset
data(NN3)
# NN3 <- loadfulldata(NN3)

# Select one series by name and plot
series <- NN3[["NN3_111"]]
ts.plot(series, ylab = "Value", xlab = "Month", main = "NN3 example series")
}
\references{
Crone, S.F., Hibon, M., & Nikolopoulos, K. (2011). \emph{Advances in forecasting with neural networks? Empirical evidence from the NN3 competition on time series prediction}. International Journal of Forecasting, 27(3), 635–660.
NN3 Competition (2007). \url{http://www.neural-forecasting-competition.com/NN3/index.htm}
}
\keyword{benchmark}
\keyword{datasets}
