% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula.R
\name{Rblatt}
\alias{Rblatt}
\title{Calculate Rosenblatt function}
\usage{
Rblatt(pc_list, data, x)
}
\arguments{
\item{pc_list}{a list of pair copulas.}

\item{data}{vector of past data values in order of occurrence.}

\item{x}{vector of arguments of Rosenblatt function.}
}
\value{
a vector of values with same length as \code{x}.
}
\description{
Evaluates the Rosenblatt function for a sequence of pair copulas extracted from an
object of class \linkS4class{dvinecopula} or \linkS4class{dvinecopula2}.
}
\details{
To set up the pair copula list, use the functions \link{mklist_dvine} for objects of
class \linkS4class{dvinecopula} or \link{mklist_dvine2} for objects
of class \linkS4class{dvinecopula2}.

The vector \code{data} containing the past values of the time series must have
at least as many elements as the list of pair copulas in \code{pc_list}. The elements
of \code{data} should be in (0,1) and the elements of \code{x} in [0,1].
}
\keyword{internal}
