% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_pi.R
\name{struct_pi}
\alias{struct_pi}
\title{Prediction Intervals for Structural Time Series with Exogenous Variables Using Importance Sampling}
\usage{
struct_pi(
  x,
  type = c("level", "trend", "BSM"),
  xreg = NULL,
  n_ahead = 1,
  level = 0.95,
  median = TRUE,
  se_limits = TRUE,
  prior = "uniform",
  custom_prior,
  custom_prior_args = NULL,
  nsim = 1000,
  inits = NULL,
  last_only = FALSE,
  return_weights = FALSE
)
}
\arguments{
\item{x}{vector containing the time series}

\item{type}{type of model. Possible options are \code{"level"}, \code{"trend"} and \code{"BSM"},
corresponding to local level, local linear trend, and local linear trend model with seasonal component.}

\item{xreg}{matrix or data frame containing the exogenous variables
(not including the intercept which is always included for non-differenced series)}

\item{n_ahead}{length of the forecast horizon.}

\item{level}{desired frequentist coverage probability of the prediction intervals.}

\item{median}{compute the median of the prediction interval.}

\item{se_limits}{compute the standard errors of the prediction interval limits.}

\item{prior}{prior to be used in importance sampling for log-sd parameters.
Defaults to uniform prior on logarithm of standard deviations (with constraints that all variances are smaller than 1e7).
If "custom", a user-defined custom prior is used (see next arguments).}

\item{custom_prior}{function for computing custom prior.
First argument must be a vector containing the log-variance parameters (observation error, level, slope, and seasonal).}

\item{custom_prior_args}{list containing additional arguments to \code{custom_prior}.}

\item{nsim}{number of simulations used in importance sampling. Default is 1000.}

\item{inits}{initial values for log-sds}

\item{last_only}{compute the prediction intervals only for the last prediction step.}

\item{return_weights}{Return (scaled) weights used in importance sampling.}
}
\value{
a list containing the prediction intervals.
}
\description{
Function \code{struct_pi} computes prediction intervals for structural time series
with exogenous variables using importance sampling.
}
\examples{

pred_StructTS <- predict(StructTS(Nile, type ="level"), n.ahead = 10, se.fit = TRUE)
pred_StructTS <- cbind(pred = pred_StructTS$pred,
  lwr = pred_StructTS$pred - qnorm(0.975)*pred_StructTS$se,
 upr = pred_StructTS$pred + qnorm(0.975)*pred_StructTS$se)

set.seed(123)
pred <- struct_pi(Nile, type = "level", n_ahead = 10)

ts.plot(ts.union(Nile,pred_StructTS, pred[,1:3]), col = c(1,2,2,2,3,3,3),
  lty = c(1,1,2,2,1,2,2))


}
\seealso{
\code{\link{tsPI}}, \code{\link{arima_pi}}
 @references
\enumerate{
 \item{Helske, J. (2015). Prediction and interpolation of time series by state space models.
 University of Jyväskylä. PhD thesis, Report 152.
 \url{https://urn.fi/URN:NBN:fi:jyu-201603111829}}
}
}
