#'@include mlcoef.R funcval.STLS.R
NULL
#'Function to be used by boot to obtain bootstrap replicates of the parameters estimated with STLS
#'
#'@param mf the \code{model.frame} containing the variables to be used when fitting the model.
#'@param mf_orig original model frame (before possible manipulations due to non-default truncation point or direction) used to ensure correct order of attributes in the call to \code{\link[truncreg]{truncreg}}
#'@param d vector of indices to define the bootstrap samples
#'@param formula a symbolic description of the model to be estimated
#'@param beta the method of determining the starting values of the regression coefficients
#'@param bet starting values to be used by \code{\link{optim}}. Only used if beta is numeric.
#'@param point the point of truncation
#'@param direction the direction of truncation
#'@param control list of control parameters to be used by \code{\link{optim}}
#'@export
#'@importFrom stats model.matrix lm optim
#'@author Anita Lindmark and Maria Karlsson


funcSTLS <- function(mf, mf_orig, d, formula, beta, bet, point, direction, control)
{
  mf2 <- mf[d,]
  x <- model.matrix(formula,data=mf2)

  y <- matrix(mf2[,1])

  if(is.numeric(beta))
  {
    bet <- bet
  }
  else
  {
    if(beta=="ols")
    {
      bet <- lm(data=mf2)$coef
      bet <- matrix(bet)
    }

    if(beta=="ml")
    {
      mlcof<-mlcoef(mf2, mf_orig)
      bet <- matrix(mlcof[-length(mlcof)])
    }
  }


  opt <- optim(par=bet,fn=funcval.STLS,control=control,x=x,y=y)

  if(direction=="right")
  {
    opt$par <- -opt$par
  }

  if(point!=0)
  {
    opt$par[1,1] <- opt$par[1,1]+(point)
  }

  b <- opt$par

  return(b)
}
