% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{ColorMapTricolore}
\alias{ColorMapTricolore}
\title{CIE-Lch Mixture of Ternary Composition}
\usage{
ColorMapTricolore(P, center, breaks, h_, c_, l_, contrast, spread)
}
\arguments{
\item{P}{n by 3 matrix of ternary compositions [p1, p2, p3](i) for
i=1, ..., n.}

\item{center}{Ternary coordinates of the grey-point.}

\item{breaks}{Number of breaks in the discrete color scale. An integer >1.
Values above 99 imply no discretization.}

\item{h_}{Primary hue of the first ternary element in angular degrees [0, 360].}

\item{c_}{Maximum possible chroma of mixed colors [0, 200].}

\item{l_}{Lightness of mixed colors [0, 100].}

\item{contrast}{Lightness contrast of the color scale [0, 1).}

\item{spread}{Spread of the color scale around center > 0.}
}
\value{
An n row data frame giving, for each row of the input P, the input
proportions [p1, p2, p3], parameters of the color mixture (h, c, l) and the
hex-rgb string of the mixed colors (rgb).
}
\description{
Return the ternary balance scheme colors for a matrix of ternary compositions.
}
\examples{
# NOTE: only intended for internal use and not part of the API
P <- prop.table(matrix(runif(9), ncol = 3), 1)
tricolore:::ColorMapTricolore(P, center = rep(1/3, 3), breaks = 4,
                              h_ = 80, c_ = 140, l_ = 80,
                              contrast = 0.4, spread = 1)

}
\keyword{internal}
