% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_angles.R
\name{determine_angles}
\alias{determine_angles}
\title{Determine angles as seen by observer}
\usage{
determine_angles(A, B, C, observer_position = c(0, 0), output_plot = TRUE,
  lines_in_plot = TRUE, angles_in_plot = TRUE, decimals_in_plot = 2)
}
\arguments{
\item{A}{A point defined by a vector containing an x- and an y-coordinate}

\item{B}{A point defined by a vector containing an x- and an y-coordinate}

\item{C}{A point defined by a vector containing an x- and an y-coordinate}

\item{observer_position}{A vector containing an x- and an y-coordinate}

\item{output_plot}{Boolean variable indicating whether a plot should be created}

\item{lines_in_plot}{Boolean variable indicating whether lines should be drawn in the plot}

\item{angles_in_plot}{Boolean variable indicating whether the angles should be printet in the plot}

\item{decimals_in_plot}{Integer indicating the number of decimals used}
}
\value{
The angles as seen by the observer expressed in radians.
}
\description{
Determine the angles (between three known points) as seen by an observer with a known position.
}
\examples{
determine_angles(A = c(0, 0), B = c(10, 0), C = c(5, 5), observer_position=c(4,1))

determine_angles(A = c(0, 0), B = c(10, 0), C = c(5, 5), observer_position=c(4,40),
angles_in_plot = FALSE)
}

