// Generated by rstantools.  Do not edit by hand.

/*
    trialr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    trialr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with trialr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_BebopInPeps2_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_BebopInPeps2");
    reader.add_event(89, 87, "end", "model_BebopInPeps2");
    return reader;
}
template <typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type
log_joint_pdf(const int& J,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& x1,
                  const std::vector<int>& x2,
                  const std::vector<int>& x3,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& lambda,
                  const T11__& psi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 10;
        local_scalar_t__ p(DUMMY_VAR__);
        (void) p;  // dummy to suppress unused var warning
        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p, DUMMY_VAR__);
        current_statement_begin__ = 11;
        stan::math::assign(p, 0);
        current_statement_begin__ = 12;
        for (int j = 1; j <= J; ++j) {
            {
            current_statement_begin__ = 14;
            local_scalar_t__ prob1(DUMMY_VAR__);
            (void) prob1;  // dummy to suppress unused var warning
            stan::math::initialize(prob1, DUMMY_VAR__);
            stan::math::fill(prob1, DUMMY_VAR__);
            current_statement_begin__ = 15;
            local_scalar_t__ prob2(DUMMY_VAR__);
            (void) prob2;  // dummy to suppress unused var warning
            stan::math::initialize(prob2, DUMMY_VAR__);
            stan::math::fill(prob2, DUMMY_VAR__);
            current_statement_begin__ = 16;
            local_scalar_t__ p_delta(DUMMY_VAR__);
            (void) p_delta;  // dummy to suppress unused var warning
            stan::math::initialize(p_delta, DUMMY_VAR__);
            stan::math::fill(p_delta, DUMMY_VAR__);
            current_statement_begin__ = 17;
            stan::math::assign(prob1, inv_logit((((alpha + (beta * get_base1(x1, j, "x1", 1))) + (gamma * get_base1(x2, j, "x2", 1))) + (zeta * get_base1(x3, j, "x3", 1)))));
            current_statement_begin__ = 18;
            stan::math::assign(prob2, inv_logit(lambda));
            current_statement_begin__ = 19;
            stan::math::assign(p_delta, ((((pow(prob1, get_base1(eff, j, "eff", 1)) * pow((1. - prob1), (1. - get_base1(eff, j, "eff", 1)))) * pow(prob2, get_base1(tox, j, "tox", 1))) * pow((1. - prob2), (1. - get_base1(tox, j, "tox", 1)))) + ((((((pow(-(1.), (get_base1(eff, j, "eff", 1) + get_base1(tox, j, "tox", 1))) * prob1) * prob2) * (1. - prob1)) * (1. - prob2)) * (stan::math::exp(psi) - 1.)) / (stan::math::exp(psi) + 1.))));
            current_statement_begin__ = 23;
            stan::math::assign(p, (p + stan::math::log(p_delta)));
            }
        }
        current_statement_begin__ = 25;
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct log_joint_pdf_functor__ {
    template <typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
        typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type
    operator()(const int& J,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& x1,
                  const std::vector<int>& x2,
                  const std::vector<int>& x3,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& lambda,
                  const T11__& psi, std::ostream* pstream__) const {
        return log_joint_pdf(J, eff, tox, x1, x2, x3, alpha, beta, gamma, zeta, lambda, psi, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_BebopInPeps2
  : public stan::model::model_base_crtp<model_BebopInPeps2> {
private:
        int J;
        std::vector<int> eff;
        std::vector<int> tox;
        std::vector<int> x1;
        std::vector<int> x2;
        std::vector<int> x3;
        double alpha_mean;
        double alpha_sd;
        double beta_mean;
        double beta_sd;
        double gamma_mean;
        double gamma_sd;
        double zeta_mean;
        double zeta_sd;
        double lambda_mean;
        double lambda_sd;
        double psi_mean;
        double psi_sd;
public:
    model_BebopInPeps2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_BebopInPeps2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_BebopInPeps2_namespace::model_BebopInPeps2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 0);
            current_statement_begin__ = 31;
            validate_non_negative_index("eff", "J", J);
            context__.validate_dims("data initialization", "eff", "int", context__.to_vec(J));
            eff = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("eff");
            pos__ = 0;
            size_t eff_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < eff_k_0_max__; ++k_0__) {
                eff[k_0__] = vals_i__[pos__++];
            }
            size_t eff_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "eff[i_0__]", eff[i_0__], 0);
                check_less_or_equal(function__, "eff[i_0__]", eff[i_0__], 1);
            }
            current_statement_begin__ = 32;
            validate_non_negative_index("tox", "J", J);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(J));
            tox = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < tox_k_0_max__; ++k_0__) {
                tox[k_0__] = vals_i__[pos__++];
            }
            size_t tox_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tox[i_0__]", tox[i_0__], 0);
                check_less_or_equal(function__, "tox[i_0__]", tox[i_0__], 1);
            }
            current_statement_begin__ = 33;
            validate_non_negative_index("x1", "J", J);
            context__.validate_dims("data initialization", "x1", "int", context__.to_vec(J));
            x1 = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("x1");
            pos__ = 0;
            size_t x1_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < x1_k_0_max__; ++k_0__) {
                x1[k_0__] = vals_i__[pos__++];
            }
            size_t x1_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < x1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x1[i_0__]", x1[i_0__], 0);
                check_less_or_equal(function__, "x1[i_0__]", x1[i_0__], 1);
            }
            current_statement_begin__ = 34;
            validate_non_negative_index("x2", "J", J);
            context__.validate_dims("data initialization", "x2", "int", context__.to_vec(J));
            x2 = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("x2");
            pos__ = 0;
            size_t x2_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < x2_k_0_max__; ++k_0__) {
                x2[k_0__] = vals_i__[pos__++];
            }
            size_t x2_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < x2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x2[i_0__]", x2[i_0__], 0);
                check_less_or_equal(function__, "x2[i_0__]", x2[i_0__], 1);
            }
            current_statement_begin__ = 35;
            validate_non_negative_index("x3", "J", J);
            context__.validate_dims("data initialization", "x3", "int", context__.to_vec(J));
            x3 = std::vector<int>(J, int(0));
            vals_i__ = context__.vals_i("x3");
            pos__ = 0;
            size_t x3_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < x3_k_0_max__; ++k_0__) {
                x3[k_0__] = vals_i__[pos__++];
            }
            size_t x3_i_0_max__ = J;
            for (size_t i_0__ = 0; i_0__ < x3_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "x3[i_0__]", x3[i_0__], 0);
                check_less_or_equal(function__, "x3[i_0__]", x3[i_0__], 1);
            }
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_sd", alpha_sd, 0);
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_sd", beta_sd, 0);
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "gamma_mean", "double", context__.to_vec());
            gamma_mean = double(0);
            vals_r__ = context__.vals_r("gamma_mean");
            pos__ = 0;
            gamma_mean = vals_r__[pos__++];
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "gamma_sd", "double", context__.to_vec());
            gamma_sd = double(0);
            vals_r__ = context__.vals_r("gamma_sd");
            pos__ = 0;
            gamma_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gamma_sd", gamma_sd, 0);
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "zeta_mean", "double", context__.to_vec());
            zeta_mean = double(0);
            vals_r__ = context__.vals_r("zeta_mean");
            pos__ = 0;
            zeta_mean = vals_r__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "zeta_sd", "double", context__.to_vec());
            zeta_sd = double(0);
            vals_r__ = context__.vals_r("zeta_sd");
            pos__ = 0;
            zeta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "zeta_sd", zeta_sd, 0);
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "lambda_mean", "double", context__.to_vec());
            lambda_mean = double(0);
            vals_r__ = context__.vals_r("lambda_mean");
            pos__ = 0;
            lambda_mean = vals_r__[pos__++];
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "lambda_sd", "double", context__.to_vec());
            lambda_sd = double(0);
            vals_r__ = context__.vals_r("lambda_sd");
            pos__ = 0;
            lambda_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_sd", lambda_sd, 0);
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "psi_mean", "double", context__.to_vec());
            psi_mean = double(0);
            vals_r__ = context__.vals_r("psi_mean");
            pos__ = 0;
            psi_mean = vals_r__[pos__++];
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "psi_sd", "double", context__.to_vec());
            psi_sd = double(0);
            vals_r__ = context__.vals_r("psi_sd");
            pos__ = 0;
            psi_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "psi_sd", psi_sd, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 54;
            num_params_r__ += 1;
            current_statement_begin__ = 55;
            num_params_r__ += 1;
            current_statement_begin__ = 56;
            num_params_r__ += 1;
            current_statement_begin__ = 57;
            num_params_r__ += 1;
            current_statement_begin__ = 58;
            num_params_r__ += 1;
            current_statement_begin__ = 59;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_BebopInPeps2() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 54;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 56;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 57;
        if (!(context__.contains_r("zeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "zeta", "double", context__.to_vec());
        double zeta(0);
        zeta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(zeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 58;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "lambda", "double", context__.to_vec());
        double lambda(0);
        lambda = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 59;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 54;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();
            current_statement_begin__ = 55;
            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();
            current_statement_begin__ = 56;
            local_scalar_t__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();
            current_statement_begin__ = 57;
            local_scalar_t__ zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.scalar_constrain(lp__);
            else
                zeta = in__.scalar_constrain();
            current_statement_begin__ = 58;
            local_scalar_t__ lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.scalar_constrain(lp__);
            else
                lambda = in__.scalar_constrain();
            current_statement_begin__ = 59;
            local_scalar_t__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_constrain(lp__);
            else
                psi = in__.scalar_constrain();
            // transformed parameters
            current_statement_begin__ = 63;
            validate_non_negative_index("prob_eff", "6", 6);
            std::vector<local_scalar_t__> prob_eff(6, local_scalar_t__(0));
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("prob_tox", "6", 6);
            std::vector<local_scalar_t__> prob_tox(6, local_scalar_t__(0));
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 65;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 1)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 66;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 1))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 67;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 68;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 1)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 69;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(5), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 1))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 70;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(6), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 71;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 72;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 73;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 74;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 75;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(5), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 76;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(6), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 63;
            size_t prob_eff_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(prob_eff[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_eff" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prob_eff: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t prob_eff_i_0_max__ = 6;
            for (size_t i_0__ = 0; i_0__ < prob_eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 0);
                check_less_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 1);
            }
            current_statement_begin__ = 64;
            size_t prob_tox_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(prob_tox[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prob_tox: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t prob_tox_i_0_max__ = 6;
            for (size_t i_0__ = 0; i_0__ < prob_tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 0);
                check_less_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 1);
            }
            // model body
            current_statement_begin__ = 80;
            lp_accum__.add(normal_log(alpha, alpha_mean, alpha_sd));
            current_statement_begin__ = 81;
            lp_accum__.add(normal_log(beta, beta_mean, beta_sd));
            current_statement_begin__ = 82;
            lp_accum__.add(normal_log(gamma, gamma_mean, gamma_sd));
            current_statement_begin__ = 83;
            lp_accum__.add(normal_log(zeta, zeta_mean, zeta_sd));
            current_statement_begin__ = 84;
            lp_accum__.add(normal_log(lambda, lambda_mean, lambda_sd));
            current_statement_begin__ = 85;
            lp_accum__.add(normal_log(psi, psi_mean, psi_sd));
            current_statement_begin__ = 86;
            lp_accum__.add(log_joint_pdf(J, eff, tox, x1, x2, x3, alpha, beta, gamma, zeta, lambda, psi, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("zeta");
        names__.push_back("lambda");
        names__.push_back("psi");
        names__.push_back("prob_eff");
        names__.push_back("prob_tox");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_BebopInPeps2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        vars__.push_back(alpha);
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);
        double gamma = in__.scalar_constrain();
        vars__.push_back(gamma);
        double zeta = in__.scalar_constrain();
        vars__.push_back(zeta);
        double lambda = in__.scalar_constrain();
        vars__.push_back(lambda);
        double psi = in__.scalar_constrain();
        vars__.push_back(psi);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 63;
            validate_non_negative_index("prob_eff", "6", 6);
            std::vector<double> prob_eff(6, double(0));
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("prob_tox", "6", 6);
            std::vector<double> prob_tox(6, double(0));
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 65;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 1)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 66;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 1))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 67;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 68;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 1)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 69;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(5), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 1))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 70;
            stan::model::assign(prob_eff, 
                        stan::model::cons_list(stan::model::index_uni(6), stan::model::nil_index_list()), 
                        inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 0))), 
                        "assigning variable prob_eff");
            current_statement_begin__ = 71;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 72;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 73;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 74;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 75;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(5), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            current_statement_begin__ = 76;
            stan::model::assign(prob_tox, 
                        stan::model::cons_list(stan::model::index_uni(6), stan::model::nil_index_list()), 
                        inv_logit(lambda), 
                        "assigning variable prob_tox");
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 63;
            size_t prob_eff_i_0_max__ = 6;
            for (size_t i_0__ = 0; i_0__ < prob_eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 0);
                check_less_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 1);
            }
            current_statement_begin__ = 64;
            size_t prob_tox_i_0_max__ = 6;
            for (size_t i_0__ = 0; i_0__ < prob_tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 0);
                check_less_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 1);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t prob_eff_k_0_max__ = 6;
                for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                    vars__.push_back(prob_eff[k_0__]);
                }
                size_t prob_tox_k_0_max__ = 6;
                for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                    vars__.push_back(prob_tox[k_0__]);
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_BebopInPeps2";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t prob_eff_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_eff" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t prob_tox_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_tox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t prob_eff_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_eff" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t prob_tox_k_0_max__ = 6;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_tox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_BebopInPeps2_namespace::model_BebopInPeps2 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
