% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeda-functions.R
\name{treedacv}
\alias{treedacv}
\title{treeda cross validation}
\usage{
treedacv(
  response,
  predictors,
  tree,
  folds = 5,
  pvec = 1:tree$Nnode,
  k = nclasses - 1,
  center = TRUE,
  scale = TRUE,
  class.names = NULL,
  ...
)
}
\arguments{
\item{response}{The classes to be predicted.}

\item{predictors}{A matrix of predictors corresponding to the tips
of the tree.}

\item{tree}{A tree object of class \code{phylo}.}

\item{folds}{Either a single number corresponding to the number of
folds of cross-validation to perform or a vector of integers
ranging from 1 to the number of folds desired giving the partition
of the dataset.}

\item{pvec}{The values of p to use.}

\item{k}{The number of discriminating axes to keep.}

\item{center}{Center the predictors?}

\item{scale}{Scale the predictors?}

\item{class.names}{A vector giving the names of the classes.}

\item{...}{Additional arguments to be passed to \code{\link{treeda}}.}
}
\value{
A list with the value of p with minimum cv error
    (\code{p.min}), the minimum value of p with in 1 se of the
    minimum cv error (\code{p.1se}), and a data frame containing
    the loss for each fold, mean loss, and standard error of the
    loss for each value of p (\code{loss.df}).
}
\description{
Performs cross-validation of a \code{\link{treeda}} fit.
}
\examples{
data(treeda_example)
out.treedacv = treedacv(response = treeda_example$response,
    predictors = treeda_example$predictors,
    tree = treeda_example$tree,
    pvec = 1:10)
out.treedacv
}
