% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate.R
\name{tr_long_term_rate}
\alias{tr_long_term_rate}
\title{Daily treasury long-term rates}
\source{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\usage{
tr_long_term_rate(date = NULL)
}
\arguments{
\item{date}{(\code{NULL} | \code{character(1)} | \code{numeric(1)})\cr
Date in format yyyy or yyyymm. If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing the rates or \code{NULL} when no entries were found.
}
\description{
Treasury ceased publication of the 30-year constant maturity series on
February 18, 2002 and resumed that series on February 9, 2006.
To estimate a 30-year rate during that time frame, this series includes the
Treasury 20-year Constant Maturity rate and an "adjustment factor," which may be
added to the 20-year rate to estimate a 30-year rate during the period of time in
which Treasury did not issue the 30-year bonds.
}
\examples{
\donttest{
# get data for a single month
tr_long_term_rate("202212")
# or for the entire year
tr_long_term_rate(2022)
}
}
\seealso{
Other interest rate: 
\code{\link{tr_bill_rate}()},
\code{\link{tr_real_long_term}()},
\code{\link{tr_real_yield_curve}()},
\code{\link{tr_yield_curve}()}
}
\concept{interest rate}
