% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_supIGtrawl}
\alias{fit_supIGtrawl}
\title{Fits a supIG trawl function to equidistant univariate time series data}
\usage{
fit_supIGtrawl(x, Delta = 1, GMMlag = 5, plotacf = FALSE, lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is 5}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
delta: parameter in the supIG trawl

gamma: parameter in the supIG trawl

LM: The Lebesgue measure of the trawl set associated with the supIG
 trawl
}
\description{
Fits a supIG trawl function to equidistant univariate time series data
}
\details{
The trawl function is parametrised by the two parameters \eqn{\delta
 \geq 0} and \eqn{\gamma \geq 0} as follows: \deqn{g(x) =
 (1-2x\gamma^{-2})^{-1/2}\exp(\delta \gamma(1-(1-2x\gamma^{-2})^{1/2})),
 \mbox{ for }  x \le 0.} It is assumed that \eqn{\delta} and \eqn{\gamma} are
 not simultaneously equal to zero. The Lebesgue measure of the corresponding
 trawl set is given by \eqn{\gamma/\delta}.
}
