% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_cleaner.R
\name{theme_cleaner}
\alias{theme_cleaner}
\title{Customizable Minimalistic ggplot2 Theme}
\usage{
theme_cleaner(
  base_size = 12,
  base_family = "sans",
  base_color = "#70C8B8",
  base_color_title = "#03617A",
  title_text_size = ceiling(base_size * 1.1),
  subtitle_text_size = ceiling(base_size * 1.05),
  caption_color = "#19405B",
  legend_position = "top",
  vjust_title = 0,
  vjust_subtitle = 0,
  hjust_title = 0,
  hjust_subtitle = 0,
  axis_lines = FALSE,
  facets = FALSE,
  facet_text_size = base_size,
  draw_panel_border = FALSE,
  ...
)
}
\arguments{
\item{base_size}{Numeric. Default font size for plot elements. Defaults to
\code{12}.}

\item{base_family}{Character. Font family used for text in the plot. Defaults
to \code{"Work Sans"}.}

\item{base_color}{Character. Hex color code for primary plot elements (e.g.,
axis text, legend text). Defaults to \code{"#70C8B8"}.}

\item{base_color_title}{Character. Hex color code for plot title and legend
title text. Defaults to \code{"#03617A"}.}

\item{title_text_size}{Numeric. Font size for plot title text. Defaults to
\code{base_size * 1.1}.}

\item{subtitle_text_size}{Numeric. Font size for plot subtitle text. Defaults
to \code{base_size * 1.05}.}

\item{caption_color}{Character. Hex color code for plot caption text.
Defaults to \code{"#19405B"}.}

\item{legend_position}{Character. Legend position on the plot. Accepts "top",
"bottom", "left", or "right". Defaults to \code{"top"}.}

\item{vjust_title}{Numeric. Vertical justification of the plot title.
Defaults to \code{0}.}

\item{vjust_subtitle}{Numeric. Vertical justification of the plot subtitle.
Defaults to \code{0}.}

\item{hjust_title}{Numeric. Horizontal justification of the plot title.
Defaults to \code{0}.}

\item{hjust_subtitle}{Numeric. Horizontal justification of the plot subtitle.
Defaults to \code{0}.}

\item{axis_lines}{Logical. If \code{TRUE}, axis lines are drawn in \code{base_color};
otherwise, they are hidden. Defaults to \code{FALSE}.}

\item{facets}{Logical. If \code{TRUE}, additional formatting for facet plots is
applied. Defaults to \code{FALSE}.}

\item{facet_text_size}{Numeric. If \code{facets = TRUE}, size formatting for facet
text (\code{strip.text}) is applied. Defaults to \code{base_size}.}

\item{draw_panel_border}{Logical. If \code{TRUE}, a border is drawn around panels
in facet plots. Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{ggplot2::theme} for further
customization.}
}
\value{
A \code{ggplot2} theme object that can be applied to plots.
}
\description{
A flexible and customizable theme function for creating polished and
minimalistic plots using \code{ggplot2}. The \code{theme_cleaner} function provides
various options to control the appearance of plot elements, including font
styles, sizes, colors, axis lines, grid lines, legend, title, subtitle,
captions, and facet appearance. The theme is highly customizable, allowing
for the creation of visually appealing and clean plots.
}
\details{
The function customizes common plot elements like axis text, titles,
subtitles, captions, legend, and facet labels. It is designed to work with
\code{ggplot2} plots, providing a clean and professional look with minimal
styling. You can adjust various aesthetic features such as font size, color,
and legend position for maximum control over the appearance.
}
\examples{
# Create a ggplot2 plot with the theme_cleaner theme
library(ggplot2)
ggplot(mtcars, aes(x = mpg, y = wt)) +
  geom_point() +
  theme_cleaner(
    base_size = 14,
    title_text_size = 16,
    legend_position = "bottom"
  )

# Customize facet plots with theme_cleaner
ggplot(mtcars, aes(x = mpg, y = wt)) +
  geom_point() +
  facet_wrap(~cyl) +
  theme_cleaner(facets = TRUE,
  facet_text_size = 12,
  draw_panel_border = TRUE
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
