% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files_manager.R
\name{upload_file}
\alias{upload_file}
\title{Upload file to Google Drive for collaborative writing and editing}
\usage{
upload_file(
  file,
  gfile = NULL,
  gpath = "trackdown",
  shared_drive = NULL,
  hide_code = FALSE,
  path_output = NULL
)
}
\arguments{
\item{file}{character. The path of a local `.Rmd` or `.Rnw` file.}

\item{gfile}{character. The name of a Google Drive file (defaults to local
file name).}

\item{gpath}{character. (Sub)directory in My Drive or a shared drive
(optional). By default files are uploaded in the folder "trackdown". To
specify another folder the full path is required (e.g., 
"trackdown/my_folder"). Use \code{NULL} to upload directly at the root
level, although it is not recommended.}

\item{shared_drive}{character. The name of a Google Drive shared drive
(optional).}

\item{hide_code}{logical value indicating whether to remove code from the
text document (chunks and header). Placeholders of type "[[chunk-<name>]]"
are displayed instead.}

\item{path_output}{default \code{NULL}, specify the path to the output to upload
together with the other file. PDF are directly uploaded, HTML can be first
converted into PDF if package \code{pagedown} and Chrome are available.}
}
\value{
a dribble of the uploaded file (and output if specified)
}
\description{
Uploads a local file to Google Drive as a plain text document. Will only
upload the file if it doesn't already exist in the chosen location. By
default files are uploaded in the folder "trackdown", if is not available on
Google Drive, permission to create it is required to the user. To update an
already existing file see \code{\link{update_file}}. It is also possible to
upload the output (pdf or html) of the file specifying the \code{path_output}
argument. In case of html files, if \code{pagedown} package and Chrome are
available, users can decide to upload a pdf version of the html file.\cr\cr
To know more about \code{trackdown} workflow and features see
\code{\link{trackdown-package}} help page.
}
