% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{projection}
\alias{projection}
\alias{projection<-}
\alias{project}
\title{Access/Modify the Projection of a Track Table}
\usage{
projection(x)

projection(x) <- value

project(x, value)
}
\arguments{
\item{x}{A track table.}

\item{value}{A character string or a \code{\link[terra:crs]{terra::crs}}
object representing the projection of the coordinates.
\code{"+proj=longlat"} is suitable for the outputs of most GPS trackers.}
}
\value{
A track table.
}
\description{
Functions to access or modify the projection of a data table.
 Changing the projection will trigger automatically the conversion of the
 locations in the new coordinate system.
}
\note{
It is not possible to modify the projection if missing coordinates
 are present.
}
\examples{
data(short_tracks)

projection(short_tracks)
tracks_projected <- project(short_tracks, "+proj=somerc")
projection(tracks_projected)
projection(tracks_projected) <- "+proj=longlat"
projection(tracks_projected)

}
\seealso{
\code{\link[sf]{st_crs}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
