% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeresponse.R
\name{normalizeresponse}
\alias{normalizeresponse}
\title{Normalize response variable}
\usage{
normalizeresponse(
  dataset,
  Conc,
  reference_group = "0",
  Response,
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{reference_group}{Label used for the group values will be
normalized to. Defaults to 0.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A modified `dataset` with an additional column,
 `normalized response`. If `list_obj` is provided, returns this within
  a list as `list_obj$dataset`, along with summary statistics surrounding
  the reference group as `list_obj$normalize_response_summary`.
}
\description{
Express a response variable relative to a reference group.
}
\examples{
normalizeresponse(
 dataset = toxresult,
 Conc = Conc,
 Response = RFU
)
}
