################################################################################
# Performs Tang-Tang-Chan test for equivalence in paired binary data
# Author: Alexis Dinno <alexis.dinno@pdx.edu>
# version 3.1.9 
# Date: Jan 28, 2026

tost.rrp <- function(
    x=NA, y=NA,
    delta0=1, deltaupper=NA,
    exact.chisq=FALSE,
    conf.level=0.95,
    treatment1="", treatment2="", outcome="", nooutcome="",
    relevance=TRUE) {
  # Set up treatment and outcome status names based on the variables if the user 
  # has not supplied these names
  if (treatment1=="") {
    # Use the x variable's label attribute if it exists
    if (!is.null(attr(x, "labels"))) {
      treatment1 <- label(x)
      }
     # Use the x variable's names attribute if it exists
     else if (!is.null(names(x))) {
      treatment1 <- names(x)
      }
     # Otherwise use the x variable's name
     else {
      treatment1 <- gsub(".*\\$", "", toString(deparse(substitute(x))))
      }
   	}
  if (treatment2=="") {
    # Use the y variable's label attribute if it exists
    if (!is.null(attr(y,"labels"))) {
      treatment2 <- label(y)
      }
     # Use the y variable's names attribute if it exists
     else if (!is.null(names(y))) {
      treatment2 <- names(y)
      }
     # Otherwise use the y variable's name
     else {
      treatment2 <- gsub(".*\\$", "", deparse(substitute(y)))
      }
    }
  # If either outcome or nooutcome is missing use factor labes if present
  if (outcome=="") {
    if (!is.null(attr(x,"labels"))) {
      outcomes <- names(attributes(sort(x))$labels)
      outcome   <- outcomes[2]
      }
     else if (!is.null(attr(y,"labels"))) {
      outcomes <- names(attributes(sort(y))$labels)
      outcome   <- outcomes[2]
      }
    }
  if (nooutcome=="") {
    if (!is.null(attr(x,"labels"))) {
      outcomes <- names(attributes(sort(x))$labels)
      nooutcome <- outcomes[1]
      }
    else if (!is.null(attr(y,"labels"))) {
      outcomes <- names(attributes(sort(y))$labels)
      nooutcome <- outcomes[1]
      }
    }
  # Validate that x and y are binary vectors of same length
  x <- x[complete.cases(x)]
  y <- y[complete.cases(y)]
  if (!all(x %in% 0:1)) {
    stop("x must contain only binary (0/1) data")
    }
  if (!all(y %in% 0:1)) {
    stop("y must contain only binary (0/1) data")
    }
  if (length(x) != length(y)) {
    stop("x and y must be the same length")
    }
  a <- length(x[x==1 & y==1])
  b <- length(x[x==0 & y==1])
  c <- length(x[x==1 & y==0])
  d <- length(x[x==0 & y==0])
  n <- (a + b + c + d)

  # Call tost.rppi to conduct that actual test
  tost.rrpi(
    a=a, 
    b=b, 
    c=c, 
    n=n, 
    delta0=delta0, 
    deltaupper=deltaupper, 
    exact.chisq=exact.chisq, 
    treatment1=treatment1, 
    treatment2=treatment2, 
    outcome=outcome, 
    nooutcome=nooutcome, 
    conf.level=conf.level, 
    relevance=relevance)
  }
