% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan.R
\name{manhattanExtra}
\alias{manhattanExtra}
\title{Create a Manhattan plot highlighting genome-wide significant and suggestive loci}
\usage{
manhattanExtra(
  df,
  genome_wide_thresh = 5e-08,
  suggestive_thresh = 1e-06,
  flank_size = 1e+06,
  region_size = 1e+06,
  sign_thresh_color = NULL,
  sign_thresh_label_size = NULL,
  show_legend = TRUE,
  label_fontface = NULL,
  nudge_y = NULL,
  ymax = NULL,
  sign_thresh = NULL,
  label_color = NULL,
  color = NULL,
  legend_labels = NULL,
  annotate = NULL,
  ...
)
}
\arguments{
\item{df}{Dataframe, GWAS summary statistics}

\item{genome_wide_thresh}{A number. P-value threshold for genome wide significant loci (5e-08 by default)}

\item{suggestive_thresh}{A number. P-value threshold for suggestive loci (1e-06 by default)}

\item{flank_size}{A number (default = 1e6). The size of the flanking region for the significant and suggestitve snps.}

\item{region_size}{A number (default = 1e6). The size of the region for gene annotation. Increase this number for sparser annotation and decrease for denser annotation.}

\item{sign_thresh_color}{A string or vector of strings to set the color/s of the significance threshold/s}

\item{sign_thresh_label_size}{A number setting the text size of the label for the significance thresholds (default text size is 3.5)}

\item{show_legend}{A logical scalar, set to FALSE to hide the legend (default : TRUE)}

\item{label_fontface}{A string or a vector of strings. Label font “plain”, “bold”, “italic”, “bold.italic” (ggrepel argument)}

\item{nudge_y}{A number to horizontally adjust the starting position of each gene label (this is a ggrepel parameter)}

\item{ymax}{Integer, max of the y-axis, (default value: \code{ymax=(max(-log10(df$P)) + max(-log10(df$P)) * .2))}}

\item{sign_thresh}{A number or vector of numbers, setting the horizontal significance threshold (default: \code{sign_thresh=5e-8}). Set to NULL to hide the significance threshold.}

\item{label_color}{A string or a vector of strings. To change the color of the gene or variant labels}

\item{color}{A string or a vector of strings, for setting the color of the datapoints on the plot}

\item{legend_labels}{A string or vector of strings representing legend labels for the input datasets}

\item{annotate}{A number (p-value). Display annotation for variants with p-values below this threshold}

\item{...}{Additional arguments passed to other plotting functions.}
}
\value{
ggplot object
}
\description{
\code{manhattanExtra()} displays association results for the entire genome on a Manhattan plot, highlighting genome-wide significant and suggestive loci.
Required parameter is at least one dataset (dataframe) containing the association data (with columns \code{CHROM,POS,P} in upper or lowercase)

All other input parameters are optional
}
\examples{
\dontrun{
manhattanExtra(df)
}

}
