% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology_functions.R
\name{visualize_topology_thresholds}
\alias{visualize_topology_thresholds}
\title{Visualize and Compare Different Threshold Methods}
\usage{
visualize_topology_thresholds(data, plot = TRUE)
}
\arguments{
\item{data}{Numeric vector to analyze}

\item{plot}{Logical indicating whether to display plots (default: TRUE)}
}
\value{
A \code{data.frame} with one row per threshold method containing:
\describe{
\item{method}{Character. Name of the threshold calculation method.}
\item{threshold}{Numeric. The calculated threshold value.}
\item{base_size}{Integer. Number of sets in the resulting topological base.}
}
If \code{plot = TRUE}, generates three plots as side effects:
(1) Bar chart comparing threshold values by method,
(2) Bar chart comparing base sizes by method,
(3) Scatter plot showing threshold vs base size relationship.
}
\description{
This function creates a comprehensive visualization of different
threshold methods used in topology analysis. It generates three distinct plots
to help understand the relationships between different threshold methods and
their effects on topological structure.
}
\details{
Visualize Topology Thresholds
}
\examples{
\donttest{
# Generate sample data
data <- rnorm(100)

# Visualize threshold comparisons
results <- visualize_topology_thresholds(data)
}
}
