% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.group_tna_bootstrap}
\alias{summary.group_tna_bootstrap}
\title{Summarize Bootstrap Results for a Grouped Transition Network}
\usage{
\method{summary}{group_tna_bootstrap}(object, ...)
}
\arguments{
\item{object}{A \code{group_tna_bootstrap} object.}

\item{...}{Ignored.}
}
\value{
A \code{summary.group_tna_bootstrap} object containing the weight,
estimated p-value and confidence interval of each edge for each cluster.
}
\description{
Summarize Bootstrap Results for a Grouped Transition Network
}
\examples{
model <- group_tna(engagement_mmm)
# Small number of iterations for CRAN
boot <- bootstrap(model, iter = 10)
summary(boot)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
