% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_TLS.R
\name{detect_TLS}
\alias{detect_TLS}
\title{Detect Tertiary Lymphoid Structures using a KNN-density approach}
\arguments{
\item{LSP}{Character. Sample name in the global \code{ldata} list.}

\item{k}{Integer. Number of nearest neighbours to consider (default 30 - works very well on 0.325 um/px imaging).}

\item{bcell_density_threshold}{Numeric. Minimum average 1/k-distance for B cells to be considered "dense" (default 15 um).}

\item{min_B_cells}{Integer. Minimum number of B cells in a candidate TLS (default 50).}

\item{min_T_cells_nearby}{Integer. Minimum T cells within 50 um of the B-cell cluster centre (default 30).}

\item{max_distance_T}{Numeric. Radius (um) to search for surrounding T cells (default 50).}

\item{ldata}{Optional. Named list of data frames. If \code{NULL}, uses global \code{ldata}.}
}
\value{
The original data frame with two new columns:
\item{tls_id_knn}{0 = non-TLS, positive integer = TLS cluster ID}
\item{tls_center_x, tls_center_y}{Coordinates of detected TLS centres (only for TLS cells)}
}
\description{
This function identifies TLS candidates germinated with B cells (BIC) by: 1. Finding regions of high local B-cell density (KNN-based). 2. Requiring a minimum number of neighbouring T cells (T-B cell co-localisation). 3. Applying sensible size and shape filters.
}
\examples{
data(toy_ldata)
ldata <- detect_TLS("ToySample", k = 30, ldata = toy_ldata)
table(ldata[["ToySample"]]$tls_id_knn)
plot(ldata[["ToySample"]]$x, ldata[["ToySample"]]$y,
     col = ifelse(ldata[["ToySample"]]$tls_id_knn > 0, "red", "gray"),
     pch = 19, cex = 0.5, main = "Detected TLS in toy data")
}
