% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isodose.R
\name{isotitedose}
\alias{isotitedose}
\title{Dose assignment for TITE-IR designs}
\usage{
isotitedose(followup, DLT, assignment, obswin, doses, target = 1/3,
  safety = 0.05)
}
\arguments{
\item{followup}{A vector of followup times}

\item{DLT}{A vector of DLT results. \code{FALSE} or 0 is interpreted as no observed DLT and \code{TRUE} or 1 is interpreted as observed DLT.}

\item{assignment}{a vector of dose assignments. Doses should be labeled in consecutive integers from 1 to number of dose levels.}

\item{obswin}{The observation window with respect to which the MTD is defined.}

\item{doses}{An integer providing the number of doses.}

\item{target}{Target DLT rate}

\item{safety}{The safety factor to prevent overly aggressive escalation}
}
\value{
an integer specifying the recommended dose level
}
\description{
Calculate the next dose assignment for a TITE-IR design.
}
\examples{
isotitedose(followup = c(6, 5, 4, 3, 2, 1), DLT = c(0, 0, 0, 0, 0, 0),
 assignment = c(1, 1, 1, 2, 2, 2), obswin = 6, doses = 6)
}
\seealso{
\code{\link{isotitesim}} for simulations
}
