% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_sql.R
\name{install_timeseriesdb}
\alias{install_timeseriesdb}
\title{Install timeseriesdb}
\usage{
install_timeseriesdb(
  con,
  schema = "timeseries",
  verbose = FALSE,
  install_tables = TRUE,
  install_functions = TRUE
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{verbose}{boolean Should progress messages be printed? Default FALSE}

\item{install_tables}{boolean Should the tables be created? Default TRUE}

\item{install_functions}{boolean Should the functions be installed? Default TRUE}
}
\description{
Install timeseriesdb in a given PostgreSQL schema. Make sure the database user
has sufficient rights to perform the necessary operations on the schema. In the process
tables, roles, triggers and functions will be created. Also extensions will be installed and
rights will be granted and revoked from the freshly created roles.
Note also, that the functions created are created as SECURITY DEFINER roles.
}
\details{
\code{install_tables} and \code{install_functions} can be used to install components of
timeseriesdb independently (e.g. only update function definitions without touching the
table structure). They are used mainly for development purposes.
}
\concept{setup SQL functions}
