% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{db_release_update}
\alias{db_release_update}
\title{Update an Existing Release Record}
\usage{
db_release_update(
  con,
  id,
  title = NULL,
  release_date = NULL,
  datasets = NULL,
  target_year = NULL,
  target_period = NULL,
  target_frequency = NULL,
  note = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{id}{Identifier for the release e.g. 'gdb_may_2020'}

\item{title}{Display title for the release}

\item{release_date}{Timestamp when the release is to occur}

\item{datasets}{\strong{character} vector of the datasets. Dataset is a group of time series.}

\item{target_year}{Year observed in the data}

\item{target_period}{Period observed in the data (e.g. month, quarter)}

\item{target_frequency}{Frequency of the data (e.g. 4 for quarterly)}

\item{note}{Additional remarks about the release.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
a status list
}
\description{
Any parameters provided to this function will overwrite the corresponding
fields in the database. Parameters set to NA (default) will leave the
corresponding fields untouched.
For details see \code{\link{db_release_create}}.
}
\seealso{
Other calendar functions: 
\code{\link{db_dataset_get_latest_release}()},
\code{\link{db_dataset_get_next_release}()},
\code{\link{db_dataset_get_release}()},
\code{\link{db_release_cancel}()},
\code{\link{db_release_create}()},
\code{\link{db_release_list}()}
}
\concept{calendar functions}
