% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_time_series.R
\name{db_dataset_read_ts}
\alias{db_dataset_read_ts}
\title{Read all Time Series in a Dataset}
\usage{
db_dataset_read_ts(
  con,
  datasets,
  valid_on = NULL,
  respect_release_date = FALSE,
  schema = "timeseries",
  chunksize = 10000
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{datasets}{\strong{character} vector of the datasets. Dataset is a group of time series.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{respect_release_date}{\strong{boolean} indicating if it should the release embargo of a time series be respected. Defaults to FALSE. This option makes sense when the function is used in an API. In that sense, users do not have direct access to this function and therefore cannot simply switch parameters.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{chunksize}{set a limit of the number of time series requested in the function.}
}
\description{
Read all Time Series in a Dataset
}
\examples{

\dontrun{
db_dataset_create(con = connection,
                  set_name = "zrh_airport_data",
                  set_description = "Zurich airport arrivals and departures ",
                  schema = "schema")

db_ts_assign_dataset(con = connection,
                     ts_keys = c("ch.zrh_airport.departure.total",
                                 "ch.zrh_airport.arrival.total"),
                     set_name = "zrh_airport_data",
                     schema = "schema")

db_dataset_read_ts(con = connection,
                   datasets = "zrh_airport_data",
                   schema = "schema")
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()},
\code{\link{db_ts_trim_history}()}
}
\concept{time series functions}
