% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{db_collection_get_keys}
\alias{db_collection_get_keys}
\title{Get All Keys in a User Collection}
\usage{
db_collection_get_keys(
  con,
  collection_name,
  user = Sys.info()["user"],
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{collection_name}{\strong{character} name of a collection to read. Collection are bookmark lists that contain time series keys.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Reads all keys in the given collection and returns them in a vector
}
\seealso{
Other collections functions: 
\code{\link{db_collection_add_ts}()},
\code{\link{db_collection_delete}()},
\code{\link{db_collection_get_last_update}()},
\code{\link{db_collection_list}()},
\code{\link{db_collection_remove_ts}()}
}
\concept{collections functions}
