% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landmarks.R
\name{military}
\alias{military}
\title{Download the Military Installation National Shapefile into R}
\usage{
military(year = NULL, ...)
}
\arguments{
\item{year}{the data year; defaults to 2024}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Description from the US Census Bureau: "The Census Bureau includes landmarks
such as military installations in the MAF/TIGER database for
locating special features and to help enumerators during field operations. The Census Bureau adds
landmark features to the database on an as-needed basis and does not attempt to ensure that all
instances of a particular feature are included. For additional information about area landmarks, please
see Section 3.12, Landmarks (Area and Point)."
}
\details{
This file does not include the three point landmarks identified as military installation features in the
MAF/TIGER database. These point landmarks are included in the point landmark shapefile.
Although almost all military installations have assigned 8-character National Standard (GNIS) codes, the
Census Bureau has not loaded most of this data into the MAF/TIGER database. The 2020 military
shapefiles contain few values in the ANSICODE field.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
\item \code{protocol} Character string specifying the protocol to use for downloading files. Options are "ftp" or "http" (default). If "ftp", the URL will be modified to use FTP instead of HTTPS.
\item \code{timeout} Integer specifying the timeout in seconds for download operations if protocol is "ftp". Defaults to 1800 (30 minutes) to handle large files.
}
}

\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2020/TGRSHP2020_TechDoc_Ch3.pdf}
}
