% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_item.R
\name{tw_get_item}
\alias{tw_get_item}
\title{Retrieve item from the Wikidata API and returns it as a list}
\usage{
tw_get_item(id, user_agent = tidywikidatar::tw_get_user_agent())
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{user_agent}{Defaults to \code{NULL}. If not given, implicitly defaults to
current package name (\code{tidywikidatar}) and version.}
}
\value{
A list, with as many elements as the unique given id.
}
\description{
Retrieve item from the Wikidata API and returns it as a list
}
\examples{
\dontrun{
  item_l <- tw_get_item(id = "Q180099")

  tidywikidatar:::tw_extract_single(w = item_l)
}
}
