% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_weather.R
\name{summarise_weather}
\alias{summarise_weather}
\title{Summarise Weather Extremes and Key Indicators}
\usage{
summarise_weather(.data)
}
\arguments{
\item{.data}{A tibble or data frame containing daily weather data. Must include
at least a \code{mint} column for daily minimum temperatures. A \code{day} column is
recommended if \code{require_full_year = TRUE}.}
}
\value{
A tibble with one row per group, containing the following columns:
\describe{
\item{number_frost_days}{Number of days where minimum temperature is below
the frost threshold.}
\item{last_frost_day}{The day of year of the last frost (or \code{NA} if none).}
}
}
\description{
This function calculates summary metrics for weather data, including the number
of frost days and the last frost day, grouped by one or more grouping variables.
The function uses package-wide options for thresholds and year completeness.
}
\details{
The function retrieves thresholds and settings from the global tidyweather
options via \code{weather_options$get()}. The default frost threshold is
\code{weather_options$get("extreme.frost_threshold")} and \code{require_full_year} is
\code{weather_options$get("require_full_year")}. These can be changed using
\code{weather_options$set()}.

This function is designed to work with grouped tibbles (e.g., after
\code{dplyr::group_by()}), applying the summary per group.
}
\examples{
library(dplyr)

# Example weather data (daily minimum temperatures)
weather_data <- read_weather(system.file("extdata/ppd_72150.met", package = "tidyweather"))

# Summarise without grouping
weather_options$set("require_full_year" = FALSE)
summarise_weather(weather_data)

# Summarise by group (e.g., year)
weather_data_grouped <- weather_data \%>\% group_by(year)
summarise_weather(weather_data_grouped)

}
